#include <bits/stdc++.h>

using namespace std;

const int N = (int) 2e5;
const int M = 20 * N;

vector<int> a(N), b(N), st(M), lejzi(M);

void build(int l, int r, int c) {
  if (l > r) {
    return;
  }
  if (l == r) {
    st[c] = b[l];
    return;
  }
  int mid = l + r >> 1;
  build(l, mid, c * 2 + 1);
  build(mid + 1, r, c * 2 + 2);
  st[c] = st[c * 2 + 1] + st[c * 2 + 2];
}

void add(int l, int r, int x, int y, int c) {
  if (lejzi[c] != 0) {
    st[c] = 0;
    lejzi[c * 2 + 1] = lejzi[c];
    lejzi[c * 2 + 2] = lejzi[c];
    lejzi[c] = 0;
  }
  if (l > r || l > y || r < x) {
    return;
  }
  if (l >= x && r <= y) {
    lejzi[c] = 0;
    st[c] = 0;
    lejzi[c * 2 + 1] = 1;
    lejzi[c * 2 + 2] = 1;
    return;
  }
  int mid = l + r >> 1;
  add(l, mid, x, y, c * 2 + 1);
  add(mid + 1, r, x, y, c * 2 + 2);
  st[c] = st[c * 2 + 1] + st[c * 2 + 2];
}

int get(int l, int r, int x, int y, int c) {
  if (lejzi[c] != 0) {
    st[c] = 0, lejzi[c] = 0;
    lejzi[c * 2 + 1] = 1;
    lejzi[c * 2 + 2] = 1;
  }
  if (l > r || l > y || r < x) {
    return 0;
  }
  if (l >= x && r <= y) {
    return st[c];
  }
  int mid = l + r >> 1;
  return get(l, mid, x, y, c * 2 + 1) + get(mid + 1, r, x, y, c * 2 + 2);
}

void point(int l, int r, int pos, int c) {
  if (lejzi[c] != 0) {
    st[c] = 0, lejzi[c] = 0;
    lejzi[c * 2 + 1] = 1;
    lejzi[c * 2 + 2] = 1;
  }
  if (l > r || l > pos || r < pos) {
    return;
  }
  if (l == r) {
    st[c] = 1;
    lejzi[c] = 0;
    return;
  }
  int mid = l + r >> 1;
  point(l, mid, pos, c * 2 + 1);
  point(mid + 1, r, pos, c * 2 + 2);
  st[c] = st[c * 2 + 1] + st[c * 2 + 2];
}

vector<int> id(M), lejzi2(M);

void ins(int l, int r, int x, int y, int val, int c) {
    if (lejzi2[c] != 0) {
        id[c] = lejzi2[c];
        lejzi2[c * 2 + 1] = lejzi2[c * 2 + 2] = lejzi2[c];
        lejzi2[c] = 0;
    }
    if (l > r || l > y || r < x) {
        return;
    }
    if (l >= x && r <= y) {
        id[c] = val;
        lejzi2[c] = 0;
        lejzi2[c * 2 + 1] = val;
        lejzi2[c * 2 + 2] = val;
        return;
    }
    int mid = l + r >> 1;
    ins(l, mid, x, y, val, c * 2 + 1);
    ins(mid + 1, r, x, y, val, c * 2 + 2);
}

int boja(int l, int r, int pos, int c) {
    if (lejzi2[c] != 0) {
        id[c] = lejzi2[c];
        lejzi2[c * 2 + 1] = lejzi2[c];
        lejzi2[c * 2 + 2] = lejzi2[c];
        lejzi2[c] = 0;
    }
    if (l > r || l > pos || r < pos) {
        return 0;
    }
    if (l == r) {
        return id[c];
    }
    int mid = l + r >> 1;
    if(pos <= mid) return boja(l, mid, pos, c * 2 + 1);
    else return boja(mid + 1, r, pos, c * 2 + 2);
}

int main() {
  ios::sync_with_stdio(false);
  cin.tie(0);
  int n, q;
  cin >> n >> q;
  vector<vector<int>> g(n);
  for (int i = 0; i < n - 1; i++) {
    int x, y;
    cin >> x >> y;
    --x, --y;
    g[x].push_back(y);
    g[y].push_back(x);
  }
  for (int i = 0; i < n; i++) {
    cin >> a[i];
  }
  vector<int> order;
  vector<int> sz(n), p(n);
  function<void(int, int)> Dfs = [&](int u, int prv) {
    order.push_back(u);
    sz[u] = 1;
    p[u] = prv;
    for (int j : g[u]) {
      if (j != prv) {
        Dfs(j, u);
        sz[u] += sz[j];
      }
    }
  };
  Dfs(0, -1);
  vector<int> pos(n);
  for (int i = 0; i < n; i++) {
    pos[order[i]] = i;
  }
  for (int i = 0; i < n; i++) {
    int x = pos[i];
    if (i == 0 || a[x] != a[p[pos[i]]]) {
      b[pos[i]] = 1;
    } else {
      b[pos[i]] = 0;
    }
  }
  for (int i : order) {
    ins(0, n - 1, pos[i], pos[i] + sz[i] - 1, a[i], 0);
    if (i == 0 || boja(0, n - 1, pos[i], 0) != boja(0, n - 1, pos[p[i]], 0)) {
        point(0, n - 1, pos[i], 0);
    }
  }
  /*build(0, n - 1, 0);
  add(0, n - 1, 1, 3, 0);
  point(0, n - 1, 2, 0);*/
  //cout << get(0, n - 1, 1, 5, 0);
  while (q--) {
    int u, c;
    cin >> u >> c;
    --u;
    add(0, n - 1, pos[u], pos[u] + sz[u] - 1, 0);
    ins(0, n - 1, pos[u], pos[u] + sz[u] - 1, c, 0);
    if (u == 0 || boja(0, n - 1, pos[u], 0) != boja(0, n - 1, pos[p[u]], 0)) {
        point(0, n - 1, pos[u], 0);
    }
    cout << st[0] << '\n';
  }
  return 0;
}